<div>
    
    <div class="d-flex justify-content-between align-items-center mb-3">
        <h2 class="m-0">Lista de tareas</h2>
        <button class="btn btn-success" data-bs-toggle="modal" data-bs-target="#modalTarea">
            + Nueva Tarea
        </button>
    </div>

    
    <table class="table table-bordered table-hover">
        <thead class="table-light">
            <tr>
                <th>Título</th>
                <th>Descripción</th>
                <th>Estado</th>
                <th>Fecha de entrega</th>
                <th>Acción</th>
            </tr>
        </thead>
        <tbody>
            <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $tareas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $tarea): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <tr>
                <td><?php echo e($tarea->titulo); ?></td>
                <td><?php echo e($tarea->descripcion); ?></td>
                <td><?php echo e($tarea->estado->estado); ?></td>
                <td><?php echo e($tarea->fecha_entrega ?? 'No definida'); ?></td>
                <td>
                    <!--[if BLOCK]><![endif]--><?php if($tarea->estado->estado !== 'Finalizada'): ?>
                        <button class="btn btn-outline-warning btn-sm" wire:click="editar(<?php echo e($tarea->id); ?>)" data-bs-toggle="modal" data-bs-target="#modalTarea" title="Editar"><i class="bi bi-pencil-fill"></i></button>
                        <button class="btn btn-outline-success btn-sm btn-finalizar" title="Finalizar" data-id="<?php echo e($tarea->id); ?>"><i class="bi bi-check2-circle"></i></button>                    
                    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                </td>
            </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
        </tbody>
    </table>

    
    <div wire:ignore.self class="modal fade" id="modalTarea" tabindex="-1" aria-labelledby="modalTareaLabel" aria-hidden="true">
        <div class="modal-dialog">
            <form wire:submit.prevent="guardar" class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="modalTareaLabel">
                        <?php echo e($modo_edicion ? 'Editar Tarea' : 'Nueva Tarea'); ?>

                    </h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Cerrar"></button>
                </div>
                <div class="modal-body">
                    <div class="mb-3">
                        <label>Título</label>
                        <input type="text" wire:model="titulo" class="form-control">
                        <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['titulo'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <small class="text-danger"><?php echo e($message); ?></small> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                    </div>
                    <div class="mb-3">
                        <label>Descripción</label>
                        <textarea wire:model="descripcion" class="form-control"></textarea>
                    </div>
                    <div class="mb-3">
                        <label>Estado</label>
                        <select wire:model="tarea_estado_id" class="form-control">
                            <option value="">-- Selecciona estado --</option>
                            <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $estados; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $estado): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($estado->id); ?>"><?php echo e($estado->estado); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                        </select>
                        <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['tarea_estado_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <small class="text-danger"><?php echo e($message); ?></small> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                    </div>
                    <div class="mb-3">
                        <label>Fecha de entrega</label>
                        <input type="date" wire:model="fecha_entrega" class="form-control">
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" wire:click="cancelarEdicion" data-bs-dismiss="modal">Cancelar</button>
                    <button type="submit" class="btn btn-primary">
                        <?php echo e($modo_edicion ? 'Actualizar' : 'Guardar'); ?>

                    </button>
                </div>
            </form>
        </div>
    </div>
</div>
<?php $__env->startPush('scripts'); ?>
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script>
    function esperarLivewire(callback) {
        if (typeof Livewire === 'undefined') {
        console.log('⚠️ Livewire no detectado. Cargando manualmente...');
        const script = document.createElement('script');
        script.src = '/livewire/livewire.js';
        script.onload = () => {
            console.log('✅ Livewire cargado manualmente');
        };
        document.head.appendChild(script);
    }
    }

    document.addEventListener('DOMContentLoaded', () => {
        console.log('📄 DOM completamente cargado.');

        const botones = document.querySelectorAll('.btn-finalizar');

        if (botones.length === 0) {
            console.warn('⚠️ No se encontraron botones con clase .btn-finalizar');
        }

        botones.forEach((btn) => {
            btn.addEventListener('click', () => {
                const tareaId = btn.getAttribute('data-id');
                console.log(`🖱️ Clic en botón de finalizar para tarea ID: ${tareaId}`);

                Swal.fire({
                    title: '¿Finalizar tarea?',
                    text: 'No podrás deshacer este cambio.',
                    icon: 'warning',
                    showCancelButton: true,
                    confirmButtonText: 'Sí, finalizar',
                    cancelButtonText: 'Cancelar',
                }).then((result) => {
                    if (result.isConfirmed) {
                        console.log('✅ Usuario confirmó finalizar la tarea.');
                        esperarLivewire(() => {
                            console.log(`📡 Enviando evento Livewire.finalizar(${tareaId})`);
                            Livewire.emit('finalizar', parseInt(tareaId));
                        });
                    } else {
                        console.log('❌ Usuario canceló la acción.');
                    }
                });
            });
        });
    });
</script>
<?php $__env->stopPush(); ?>





<?php /**PATH C:\laragon\www\proyecto-livewire\resources\views/livewire/lista-tareas.blade.php ENDPATH**/ ?>