<div>
    {{-- Encabezado con botón --}}
    <div class="d-flex justify-content-between align-items-center mb-3">
        <h2 class="m-0">Lista de tareas</h2>
        <button class="btn btn-success" data-bs-toggle="modal" data-bs-target="#modalTarea">
            + Nueva Tarea
        </button>
    </div>

    {{-- Tabla de tareas --}}
    <table class="table table-bordered table-hover">
        <thead class="table-light">
            <tr>
                <th>Título</th>
                <th>Descripción</th>
                <th>Estado</th>
                <th>Fecha de entrega</th>
                <th>Acción</th>
            </tr>
        </thead>
        <tbody>
            @foreach($tareas as $tarea)
            <tr>
                <td>{{ $tarea->titulo }}</td>
                <td>{{ $tarea->descripcion }}</td>
                <td>{{ $tarea->estado->estado }}</td>
                <td>{{ $tarea->fecha_entrega ?? 'No definida' }}</td>
                <td>
                    @if($tarea->estado->estado !== 'Finalizada')
                        <button class="btn btn-outline-warning btn-sm" wire:click="editar({{ $tarea->id }})" data-bs-toggle="modal" data-bs-target="#modalTarea" title="Editar"><i class="bi bi-pencil-fill"></i></button>
                        <!--<button class="btn btn-outline-success btn-sm btn-finalizar" title="Finalizar" data-id="{{ $tarea->id }}"><i class="bi bi-check2-circle"></i></button>                    -->
                    @endif
                </td>
            </tr>
            @endforeach
        </tbody>
    </table>

    {{-- Modal con formulario --}}
    <div wire:ignore.self class="modal fade" id="modalTarea" tabindex="-1" aria-labelledby="modalTareaLabel" aria-hidden="true">
        <div class="modal-dialog">
            <form wire:submit.prevent="guardar" class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="modalTareaLabel">
                        {{ $modo_edicion ? 'Editar Tarea' : 'Nueva Tarea' }}
                    </h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Cerrar"></button>
                </div>
                <div class="modal-body">
                    <div class="mb-3">
                        <label>Título</label>
                        <input type="text" wire:model="titulo" class="form-control">
                        @error('titulo') <small class="text-danger">{{ $message }}</small> @enderror
                    </div>
                    <div class="mb-3">
                        <label>Descripción</label>
                        <textarea wire:model="descripcion" class="form-control"></textarea>
                    </div>
                    <div class="mb-3">
                        <label>Estado</label>
                        <select wire:model="tarea_estado_id" class="form-control">
                            <option value="">-- Selecciona estado --</option>
                            @foreach($estados as $estado)
                                <option value="{{ $estado->id }}">{{ $estado->estado }}</option>
                            @endforeach
                        </select>
                        @error('tarea_estado_id') <small class="text-danger">{{ $message }}</small> @enderror
                    </div>
                    <div class="mb-3">
                        <label>Fecha de entrega</label>
                        <input type="date" wire:model="fecha_entrega" class="form-control">
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" wire:click="cancelarEdicion" data-bs-dismiss="modal">Cancelar</button>
                    <button type="submit" class="btn btn-primary">
                        {{ $modo_edicion ? 'Actualizar' : 'Guardar' }}
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>
@push('scripts')
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script>
    function esperarLivewire(callback) {
        if (typeof Livewire !== 'undefined' && typeof Livewire.emit === 'function') {
            console.log('✅ Livewire está disponible.');
            callback();
        } else {
            console.log('⏳ Esperando que Livewire esté disponible...');
            setTimeout(() => esperarLivewire(callback), 100);
        }
    }

    document.addEventListener('DOMContentLoaded', () => {
        console.log('📄 DOM completamente cargado.');

        const botones = document.querySelectorAll('.btn-finalizar');

        if (botones.length === 0) {
            console.warn('⚠️ No se encontraron botones con clase .btn-finalizar');
        }

        botones.forEach((btn) => {
            btn.addEventListener('click', () => {
                const tareaId = btn.getAttribute('data-id');
                console.log(`🖱️ Clic en botón de finalizar para tarea ID: ${tareaId}`);

                Swal.fire({
                    title: '¿Finalizar tarea?',
                    text: 'No podrás deshacer este cambio.',
                    icon: 'warning',
                    showCancelButton: true,
                    confirmButtonText: 'Sí, finalizar',
                    cancelButtonText: 'Cancelar',
                }).then((result) => {
                    if (result.isConfirmed) {
                        console.log('✅ Usuario confirmó finalizar la tarea.');
                        esperarLivewire(() => {
                            console.log(`📡 Enviando evento Livewire.finalizar(${tareaId})`);
                            Livewire.emit('finalizar', parseInt(tareaId));
                        });
                    } else {
                        console.log('❌ Usuario canceló la acción.');
                    }
                });
            });
        });
    });
</script>
@endpush





